<?php
/**
 * ecv-2020 functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ecv-2020
 */

if ( !defined( '_S_VERSION' ) ) {
  // Replace the version number of the theme on each release.
  define( '_S_VERSION', '1.0.0' );
}

if ( !function_exists( 'ecv_2020_setup' ) ):
  /**
   * Sets up theme defaults and registers support for various WordPress features.
   *
   * Note that this function is hooked into the after_setup_theme hook, which
   * runs before the init hook. The init hook is too late for some features, such
   * as indicating support for post thumbnails.
   */
  function ecv_2020_setup() {
    /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     * If you're building a theme based on ecv-2020, use a find and replace
     * to change 'ecv-2020' to the name of your theme in all the template files.
     */
    load_theme_textdomain( 'ecv-2020', get_template_directory() . '/languages' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
     * Let WordPress manage the document title.
     * By adding theme support, we declare that this theme does not use a
     * hard-coded <title> tag in the document head, and expect WordPress to
     * provide it for us.
     */
    add_theme_support( 'title-tag' );

    /*
     * Enable support for Post Thumbnails on posts and pages.
     *
     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
     */
    add_theme_support( 'post-thumbnails' );

    

    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support(
      'html5',
      array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'style',
        'script',
      )
    );

    // Set up the WordPress core custom background feature.
    add_theme_support(
      'custom-background',
      apply_filters(
        'ecv_2020_custom_background_args',
        array(
          'default-color' => 'ffffff',
          'default-image' => '',
        )
      )
    );

    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );

    /**
     * Add support for core custom logo.
     *
     * @link https://codex.wordpress.org/Theme_Logo
     */
    add_theme_support(
      'custom-logo',
      array(
        'height' => 250,
        'width' => 250,
        'flex-width' => true,
        'flex-height' => true,
      )
    );
  }
endif;
add_action( 'after_setup_theme', 'ecv_2020_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ecv_2020_content_width() {
  $GLOBALS[ 'content_width' ] = apply_filters( 'ecv_2020_content_width', 640 );
}
add_action( 'after_setup_theme', 'ecv_2020_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ecv_2020_widgets_init() {
  register_sidebar(
    array(
      'name' => esc_html__( 'Sidebar', 'ecv-2020' ),
      'id' => 'sidebar-1',
      'description' => esc_html__( 'Add widgets here.', 'ecv-2020' ),
      'before_widget' => '<section id="%1$s" class="widget %2$s">',
      'after_widget' => '</section>',
      'before_title' => '<h2 class="widget-title">',
      'after_title' => '</h2>',
    )
  );
}
add_action( 'widgets_init', 'ecv_2020_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ecv_2020_scripts() {
  wp_enqueue_style( 'ecv-2020-style', get_stylesheet_uri(), array(), _S_VERSION );
  wp_style_add_data( 'ecv-2020-style', 'rtl', 'replace' );

  wp_enqueue_script( 'ecv-2020-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

  if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
    wp_enqueue_script( 'comment-reply' );
  }
}
add_action( 'wp_enqueue_scripts', 'ecv_2020_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
  require get_template_directory() . '/inc/jetpack.php';
}

/*--------------------------------------*/
/*FONCTIONS ADITIONNELLES - YR-2020*/
/*--------------------------------------*/
// Autoriser les fichiers SVG 
function wpc_mime_types($mimes) {
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'wpc_mime_types');

//-------------------------------
// Suppression des commentaires dans le site
add_filter( 'comments_open', 'wpc_comments_closed', 10, 2 );

function wpc_comments_closed( $open, $post_id ) {
  $post = get_post( $post_id );
  $open = false;
  return $open;
}

//-------------------------------
//Suppression des commentaires dans le menu de l'administration*/
function remove_menu_items() {
  global $menu;
  $restricted = array(
    __( 'Links' ),
    __( 'Comments' )
  );
  end( $menu );
  while ( prev( $menu ) ) {
    $value = explode( ' ', $menu[ key( $menu ) ][ 0 ] );
    if ( in_array( $value[ 0 ] != NULL ? $value[ 0 ] : "", $restricted ) ) {
      unset( $menu[ key( $menu ) ] );
    }
  }
}
add_action( 'admin_menu', 'remove_menu_items' );

//-------------------------------
//Activ Dashicon in front (https://developer.wordpress.org/resource/dashicons/)
add_action( 'wp_enqueue_scripts', 'load_dashicons_front_end' );
function load_dashicons_front_end() {
  wp_enqueue_style( 'dashicons' );
}

//-------------------------------
// Définition des menus et de leurs emplacements
register_nav_menus( array(
  'Top' => 'Navigation principale',
  'Bottom' => 'Menu pied de page'
) );

//-------------------------------
//jQuery & Custom scripts
function enqueue_scripts() {
  $js_directory = get_template_directory_uri() . '/js/';
  wp_register_script( 'global', $js_directory . 'global.js', 'jquery', '1.0' );
  wp_enqueue_script( 'global' );
}
add_action( 'wp_enqueue_scripts', 'enqueue_scripts' );

//-------------------------------
// Load the theme stylesheets
function theme_styles()  
{ 
	// Load all of the styles that need to appear on all pages
	wp_enqueue_style( 'main', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'custom', get_template_directory_uri() . '/css/custom.css' );

	
}
add_action('wp_enqueue_scripts', 'theme_styles');